' Started....2/09/21 version2 06/05/2022
' Microcontroller used:  Microchip Technology PIC16F88
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------
  'Fix for RB7 not being made an analogue input
' When the switch is closed the servo moves through 45 degrees when the switch
' opens it moves back to start. The potentiometers enable you to trim the start and
'end positions to align with the signal lights. When the signal is horizontal the RED
'LED is on. When the signal is in the down position the green LED is on.

'
'
' 
   #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 #ENDCONFIG                                                                                                                                        
 
 
    
    Define  ADC_BITS     10    ' Set number of bits in result
	Define  ADC_CLOCK    3     ' Set clock source (3=rc)
	Define  ADC_SAMPLEUS 50    ' Set sampling time in uS
    
     
       
'------------Variables-------------
   x  var word  ' adc RB7
   y var word   '2 * adc RB7
   b var word   'ms delay between servo step
   e var word   'adc RA0
   f var word   ' 2 * adc RA0
          ' ADC reading 
'----------Initialization----------
    ANSEL = %01000001  ' RA0,RB7 ADC analogue inputs rest digital
    TRISB = %10000001 ' RB0 switch input, RB7 ADC input rest outputs                   
    TRISA = %00100001 'RA0 ADC input and RA5 reset input, rest outputs                  
   ADCON1 = %10000000  ' Bit 7 Right justifies 10-bit value of x
                       ' in 16-bit WORD. ie ADC 0 to 1024 from Vref- to +5V. Vref-ve to 0V2
   
   ADCON0.0 = 1 'ADC on                                 
   OSCCON = $60	 ' Sets the internal oscillator in the
                     ' 16F88 to 4 MHz   	    
                      
    
  
  x = 0
  y = 0  'pot sets this to 1400 RB7
  b = 20
  e = 0
  f = 0  'pot sets this to 1900 RA0
  PORTB.2 = 0  'red LED off
  PORTB.5 = 0  'green LED off
 
   
'-------------Main Code------------
  PAUSE 300 ' Wait 0.5 sec for LCD to initialize
  ADCON0.5 = 1  'RB7 ADC input
  ADCON0.4 = 1  'RB7 ADC input
  ADCON0.3 = 0  'RB7 ADC input
  
  ADCIN 6,X 'read ADC on RB7 and store 10 bit number in X 
 y = x * 2 
  ADCON0.5 = 0  'RA0 ADC input
  ADCON0.4 = 0  'RA0 ADC input
  ADCON0.3 = 0   'RA0 ADC input 
  adcin 0, e
  f = e * 2
  
  
  Start:
  if PORTB.0 = 0 then goto Display
  if PORTB.0 = 1 then goto D
 Display:
 PORTB.2 = 0 'red LED off
 PORTB.5 = 1'green LED on
 
PORTB.1 = 1
pauseus 7' set to 1400 by pot from RB7
PORTB.1 = 0 
pause b  
PORTB.1 = 1
pauseus 1450
PORTB.1 = 0 
pause b  
PORTB.1 = 1
pauseus 1500
PORTB.1 = 0 
pause b  
PORTB.1 = 1
pauseus 1550
PORTB.1 = 0 
pause b  
PORTB.1 = 1
pauseus 1600
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1650
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1700
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1750
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1800
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1850
PORTB.1 = 0 
pause b  
Up:
 ADCON0.5 = 0  'RA0 ADC input
 ADCON0.4 = 0  'RA0 ADC input
 ADCON0.3 = 0   'RA0 ADC input 
ADCIN 0,e 'read ADC on RA0 and store 10 bit number in e 
 f = e * 2   
PORTB.1 = 1
pauseus f
PORTB.1 = 0 
pause b


if PORTB.0 = 0 then goto UP
if PORTB.0 = 1 then goto D
D:
PORTB.2 = 1 'red LED on
PORTB.5 = 0'green LED off
PORTB.1 = 1
pauseus 1850
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1800
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1750
PORTB.1 = 0 
pause b 
PORTB.1 = 1
pauseus 1700
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1650
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1600
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1550
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1500
PORTB.1 = 0 
pause b
PORTB.1 = 1
pauseus 1450
PORTB.1 = 0 
pause b
Down:
 ADCON0.5 = 1  'RB7 ADC input
 ADCON0.4 = 1  'RB7 ADC input
 ADCON0.3 = 0  'RB7 ADC input
 ADCIN 6,X 'read ADC on RB7 and store 10 bit number in X 
 y = x * 2 
PORTB.1 = 1
pauseus y
PORTB.1 = 0 
pause b 
if PORTB.0 = 1 then goto Down
if PORTB.0 = 0 then goto Start

